<?php
/**
 * SMS RU. Version 3.0.0
 * @package Joomla.JoomShopping
 * @author Alexandr Artamonov
 * @website http://w3strict.ru/
 * @email info@w3strict.ru
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined("_JEXEC") or die("Restricted access");
jimport('joomla.application.component.controller');

class plgJShoppingCheckoutSMS_RU extends JPlugin
{
    public function onEndCheckoutStep5(&$order){
        // Get plugin params
        $tableAddon = JTable::getInstance("Addon", "JShop");
		$tableAddon->loadAlias("sms_ru");
		$params = $tableAddon->getParams();
        
        if(!$params['enable']) return;

        JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
        
        $ch = curl_init("http://sms.ru/sms/send");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $this->__getPostArray($order, $params));
        curl_exec($ch);
        curl_close($ch);
        
        if($params['send_user_new_order_status']){
        	$phone_field = $params['send_user_new_order_status_phone_field'];
        	$remove = array("+", "(", ")", " ", "-");
        	$user_phone = str_replace($remove, "", $order->$phone_field);
        	if($user_phone){
        		
        		$ch = curl_init("http://sms.ru/sms/send");
        		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        		curl_setopt($ch, CURLOPT_POSTFIELDS, $this->__getPostArray($order, $params, $user_phone));
        		$body = curl_exec($ch);
        		curl_close($ch);
        		$code = explode("\n", $body);
        		if ($code[0]!="100") {
        			JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_FRONT_ERROR_SEND_SMS'),'warning');
        			echo $body;
        		} 
        		
        	}
        }
    }
    
    /**
     * Create the post array
     * 
     * @param $order  Object with order data
     * @param $params Plugin parameters
     * 
     * @return Array
     */
    protected function __getPostArray($order, $params, $to = false){
    	
    	if($to == false){
    		$sending_text = $this->__getSendingText($order, $params['sms_text']);
    	}else{
    		$sending_text = $this->__getSendingText($order, $params['send_user_new_order_text']);
    	}
        $return = Array(
            	"to"			=>	$to ? $to:$params['phones'],
            	"text"		    =>	$sending_text,
                "partner_id"    =>  '62999'
        );
        if($params['hardauth_enabled'] && $params['login'] && $params['password']){
            // Get token
            $ch = curl_init("http://sms.ru/auth/get_token");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            $token = curl_exec($ch);
            curl_close($ch);
            // Generate array
            $return = array_merge(array(
            	"login"		    =>	$params['login'],
            	"token"		    =>	$token
            ),$return);
            
	        if($params['api_id']){
	        	$return["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
	        }else{
	        	$return["sha512"] = hash("sha512",$params['password'].$token);
	        }
        }else{
            $return = array_merge(array(
            	"api_id"		=>	$params['api_id']
            ),$return);
        }
        
        if($to == false){
	        if($params['translit'] == 1){
	        	$return = array_merge(array("translit" => '1'),$return);
	        }elseif($params['translit'] == '-1'){
	        	if(strlen($sending_text) > 69 ){
	        		$return = array_merge(array("translit" => '1'),$return);
	        	}
	        }
        }else{
        	if($params['send_user_new_order_translit'] == 1){
        		$return = array_merge(array("translit" => '1'),$return);
        	}elseif($params['send_user_new_order_translit'] == '-1'){
        		if(strlen($sending_text) > 69 ){
        			$return = array_merge(array("translit" => '1'),$return);
        		}
        	}
        }
        if($params['senders']){
        	$return = array_merge(array("from" => $params['senders']),$return);
        }
        
        return $return;
    }
    /**
     * Creates the final version of the message
     * 
     * @param $order  Object with order data
     * @param $params Plugin parameters
     * 
     * @return string  Message text
     */
    protected function __getSendingText($order, $text){
        $s = array('{sms_ru_orderid}','{sms_ru_fname}','{sms_ru_lname}','{sms_ru_client_type}','{sms_ru_firma}','{sms_ru_code_firma}','{sms_ru_code_nds}','{sms_ru_email}',
            '{sms_ru_birthday}','{sms_ru_home}','{sms_ru_apartment}','{sms_ru_street}','{sms_ru_postcode}','{sms_ru_city}','{sms_ru_state}','{sms_ru_country}',
            '{sms_ru_phone}','{sms_ru_mobil_phone}','{sms_ru_fax}','{sms_ru_cost}','{sms_ru_d_fname}','{sms_ru_d_lname}','{sms_ru_d_firma}','{sms_ru_d_email}',
            '{sms_ru_d_birthday}','{sms_ru_d_home}','{sms_ru_d_apartment}','{sms_ru_d_street}','{sms_ru_d_postcode}','{sms_ru_d_city}','{sms_ru_d_state}',
            '{sms_ru_d_country}','{sms_ru_d_phone}','{sms_ru_d_mobil_phone}','{sms_ru_d_fax}');
        // Replace country code
        if(strstr($text, '{sms_ru_country}')){
	        $row = JTable::getInstance('country', 'jshop');
	        $row->load($order->country);
	        $lang_tag = 'name_'.JFactory::getLanguage()->getTag();
        	$country = $row->$lang_tag;
        }else{
        	$country = $order->country;
        }
		
		// Format cost
		if(strstr($text, '{sms_ru_cost}')){
			$order_total = formatprice($order->order_total);
		}
        
        $r = array($order->order_id,$order->f_name,$order->l_name,$order->client_type,$order->firma_name,$order->firma_code,$order->tax_number,$order->email,
            $order->birthday,$order->home,$order->apartment,$order->street,$order->zip,$order->city,$order->state,$country,
            $order->phone,$order->mobil_phone,$order->fax,$order_total,$order->d_f_name,$order->d_l_name,$order->d_firma_name,$order->d_email,
            $order->d_birthday,$order->d_home,$order->d_apartment,$order->d_street,$order->d_zip,$order->d_city,$order->d_state,
            $order->d_country,$order->d_phone,$order->d_mobil_phone,$order->d_fax);
        return str_replace($s, $r, $text);
    }
}