<?php
/**
 * SMS RU. Version 3.0.0
 * @package Joomla.JoomShopping
 * @author Alexandr Artamonov
 * @website http://w3strict.ru/
 * @email info@w3strict.ru
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined("_JEXEC") or die("Restricted access");

$options = array();

$options[] = JHtml::_('select.option', 0, JText::_('SMS_RU_SENDERS_NONE'));
 
// Get plugin params
$tableAddon = JTable::getInstance("Addon", "JShop");
$tableAddon->loadAlias("sms_ru");
$params = $tableAddon->getParams();

if($params['hardauth_enabled'] && $params['login'] && $params['password']){
	$ch = curl_init("http://sms.ru/auth/get_token");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	$token = curl_exec($ch);
	curl_close($ch);

	$ch = curl_init("http://sms.ru/my/senders");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	$post_array = array(

			"login"		    =>	$params['login'],
			"token"		    =>	$token

	);
	if($params['api_id']){
		$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
	}else{
		$post_array["sha512"] = hash("sha512",$params['password'].$token);
	}
	curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
	$body = curl_exec($ch);
}else{
	$ch = curl_init("http://sms.ru/my/senders");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	curl_setopt($ch, CURLOPT_POSTFIELDS, array(
	"api_id"		=>	$params['api_id']
	));
	$body = curl_exec($ch);
	curl_close($ch);
}
 
$reply = array_filter(explode("\n", $body));
$code = array_shift($reply);
if ($code=="100") {
	$senders = $reply;
	foreach ($senders as $sender) {
		$options[] = JHtml::_('select.option', $sender, $sender);
	}
}
$html[] = JHtml::_('select.genericlist', $options, 'send-custom-text-senders', '', 'value', 'text');

$senders = implode($html);

?><div class="row-fluid">
	<div class="span9">
		<div class="control-group">
			<div class="control-label">
				<label id="send-custom-phones" for="send-custom-phones-input" class="hasTooltip" data-original-title="
					<strong><?php echo JText::_('SMS_RU_SENDCUSTOM_TO')?></strong><br /><?php echo JText::_('SMS_RU_SENDCUSTOM_TO_DESC')?>">
					<?php echo JText::_('SMS_RU_SENDCUSTOM_TO')?>
				</label>
			</div>
			<div class="controls">
				<input type="text" name="send-custom-phones" id="send-custom-phones-input" data-role="tagsinput" placeholder="89261234567" />
			</div>
		</div>
		<div class="control-group">
			<div class="control-label">
				<label id="params_translit_-lbl" class="hasTooltip" title="<strong><?php echo JText::_('SMS_RU_TRANSLIT')?></strong><br /><?php echo JText::_('SMS_RU_TRANSLIT_DESC')?>"><?php echo JText::_('SMS_RU_TRANSLIT')?></label>
			</div>
			<div class="controls">
				<fieldset id="params_translit_" class="radio radio btn-group" >
					<input type="radio" id="send-custom-translit_0" name="send-custom-translit" value="1" />
					<label for="send-custom-translit_0" ><?php echo JText::_('JYES')?></label>
					<input type="radio" id="send-custom-translit_1" name="send-custom-translit" value="-1" />
					<label for="send-custom-translit_1" ><?php echo JText::_('SMS_RU_AUTO')?></label>
					<input type="radio" id="send-custom-translit_2" name="send-custom-translit" value="0" checked="checked" />
					<label for="send-custom-translit_2" ><?php echo JText::_('JNO')?></label>
				</fieldset>			
			</div>
		</div>
		<div class="control-group">
			<div class="control-label">
				<label id="send-custom-phones" for="send-custom-text-textarea" class="hasTooltip" data-original-title="
					<strong><?php echo JText::_('SMS_RU_SENDCUSTOM_TEXT')?></strong><br /><?php echo JText::_('SMS_RU_SENDCUSTOM_TEXT_DESC')?>">
					<?php echo JText::_('SMS_RU_SENDCUSTOM_TEXT')?>
				</label>
			</div>
			<div class="controls">
				<textarea name="send-custom-text" id="send-custom-text-textarea"></textarea>
				<ul id="sms-counter">
				    <li><?php echo JText::_('SMS_RU_SENDCUSTOM_ENCODING')?>: <span class="encoding"></span></li>
				    <li><?php echo JText::_('SMS_RU_SENDCUSTOM_LENGH')?>: <span class="length"></span></li>
				    <li><?php echo JText::_('SMS_RU_SENDCUSTOM_MESSAGES')?>: <span class="messages"></span></li>
				    <li><?php echo JText::_('SMS_RU_SENDCUSTOM_PERMESSAGE')?>: <span class="per_message"></span></li>
				    <li><?php echo JText::_('SMS_RU_SENDCUSTOM_REMAINING')?>: <span class="remaining"></span></li>
				</ul>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label">
				<label id="send-custom-senders" for="send-custom-text-senders">
					<?php echo JText::_('SMS_RU_SENDERS')?>
				</label>
			</div>
			<div class="controls">
				<?php echo $senders?>
			</div>
		</div>
	</div>
</div>
<?php /// $document->addScript('/components/com_jshopping/addons/sms_ru/assets/js/sms_counter.js');?>
<script type="text/javascript">
jQuery( document ).ready(function($) {
	(function() {
		  var $, SmsCounter;

		  window.SmsCounter = SmsCounter = (function() {
		    function SmsCounter() {}

		    SmsCounter.gsm7bitChars = "@£$¥èéùìòÇ\\nØø\\rÅåΔ_ΦΓΛΩΠΨΣΘΞÆæßÉ !\\\"#¤%&'()*+,-./0123456789:;<=>?¡ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÑÜ§¿abcdefghijklmnopqrstuvwxyzäöñüà";

		    SmsCounter.gsm7bitExChar = "\\^{}\\\\\\[~\\]|€";

		    SmsCounter.gsm7bitRegExp = RegExp("^[" + SmsCounter.gsm7bitChars + "]*$");

		    SmsCounter.gsm7bitExRegExp = RegExp("^[" + SmsCounter.gsm7bitChars + SmsCounter.gsm7bitExChar + "]*$");

		    SmsCounter.gsm7bitExOnlyRegExp = RegExp("^[\\" + SmsCounter.gsm7bitExChar + "]*$");

		    SmsCounter.GSM_7BIT = 'GSM_7BIT';

		    SmsCounter.GSM_7BIT_EX = 'GSM_7BIT_EX';

		    SmsCounter.UTF16 = 'UTF16';

		    SmsCounter.messageLength = {
		      GSM_7BIT: 160,
		      GSM_7BIT_EX: 160,
		      UTF16: 70
		    };

		    SmsCounter.multiMessageLength = {
		      GSM_7BIT: 153,
		      GSM_7BIT_EX: 153,
		      UTF16: 67
		    };
		    
		    SmsCounter.count = function(text) {
		      if(jQuery('input[name=send-custom-translit]:checked').val() != 0){
		        SmsCounter.messageLength = {
		          GSM_7BIT: 160,
		          GSM_7BIT_EX: 160,
		          UTF16: 160
		        };
		    
		        SmsCounter.multiMessageLength = {
		          GSM_7BIT: 153,
		          GSM_7BIT_EX: 153,
		          UTF16: 153
		        };
		      }else{
		        SmsCounter.messageLength = {
		          GSM_7BIT: 160,
		          GSM_7BIT_EX: 160,
		          UTF16: 70
		        };
		    
		        SmsCounter.multiMessageLength = {
		          GSM_7BIT: 153,
		          GSM_7BIT_EX: 153,
		          UTF16: 67
		        };
		      }
		      var count, encoding, length, messages, per_message, remaining;
		      encoding = this.detectEncoding(text);
		      length = text.length;
		      if (encoding === this.GSM_7BIT_EX) {
		        length += this.countGsm7bitEx(text);
		      }
		      per_message = this.messageLength[encoding];
		      if (length > per_message) {
		        per_message = this.multiMessageLength[encoding];
		      }
		      messages = Math.ceil(length / per_message);
		      remaining = (per_message * messages) - length;
		      return count = {
		        encoding: encoding,
		        length: length,
		        per_message: per_message,
		        remaining: remaining,
		        messages: messages
		      };
		    };

		    SmsCounter.detectEncoding = function(text) {
		      switch (false) {
		        case text.match(this.gsm7bitRegExp) == null:
		          return this.GSM_7BIT;
		        case text.match(this.gsm7bitExRegExp) == null:
		          return this.GSM_7BIT_EX;
		        default:
		          return this.UTF16;
		      }
		    };

		    SmsCounter.countGsm7bitEx = function(text) {
		      var char2, chars;
		      chars = (function() {
		        var _i, _len, _results;
		        _results = [];
		        for (_i = 0, _len = text.length; _i < _len; _i++) {
		          char2 = text[_i];
		          if (char2.match(this.gsm7bitExOnlyRegExp) != null) {
		            _results.push(char2);
		          }
		        }
		        return _results;
		      }).call(this);
		      return chars.length;
		    };

		    return SmsCounter;

		  })();

		  if (typeof jQuery !== "undefined" && jQuery !== null) {
		    $ = jQuery;
		    $.fn.countSms = function(target) {
		      var count_sms, input;
		      input = this;
		      target = $(target);
		      count_sms = function() {
		        var count, k, v, _results;
		        count = SmsCounter.count(input.val());
		        _results = [];
		        for (k in count) {
		          v = count[k];
		          _results.push(target.find("." + k).text(v));
		        }
		        return _results;
		      };
		      this.on('keyup', count_sms);
		      jQuery('input[name=send-custom-translit]').change(count_sms);
		      return count_sms();
		    };
		  }

		}).call(this);
	$('#send-custom-text-textarea').countSms('#sms-counter')
});
</script>