<?php
/**
 * SMS RU. Version 2.0.0
 * @package Joomla.JoomShopping
 * @author Alexandr Artamonov
 * @website http://w3strict.ru/
 * @email info@w3strict.ru
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined("_JEXEC") or die("Restricted access");

class JFormFieldSmsRu extends JFormField {

	protected $form;
	protected $params;
	
	public function __construct($name, $params = array(), $data = '') {
		if (!$data) {
			$data = dirname(__FILE__).'/form.xml';
		}
		$this->params = $params;
		$this->form = JForm::getInstance($name, $data);
	}

	protected function getInput() {
	}
	
	public function getInputByName($name) {
		return $this->form->getInput('params['.$name.']', null, $this->params->$name);
	}
	
	public function getLabelByName($name) {
		return $this->form->getLabel('params['.$name.']');
	}

}
$this->params = (object)$this->params;
JFactory::getLanguage()->load("sms_ru", dirname(__FILE__), '', true);

$document = JFactory::getDocument();
$form = new JFormFieldSmsRu('sms_ru', $this->params);
//var_dump($params['limit']);
if($params['balance'] !== FALSE && $params['limit'] !== FALSE){?>
<div class="row-fluid">
	<div class="span12">
		<p class="pull-right user-data<?php if((int)$params['balance'] < 10){echo ' red-balance';}elseif((int)$params['balance'] < 100){echo ' yellow-balance';}else{echo' green-balance';}?>">
			<span class="balance"><?php echo JText::_('SMS_RU_USERPANEL_BALANCE').$params['balance'];?></span>
            <span class="limit"><?php echo JText::_('SMS_RU_USERPANEL_LIMIT').$params['limit'];?></span>
		</p>
	</div>
</div>
<?php }
$this->bootstrap = version_compare(JVERSION,'3.0.0','>=');
if ($this->bootstrap) {
	jimport('joomla.html.html.bootstrap');
	JHtml::_('bootstrap.tooltip');
} else {
    $document->addScript('/components/com_jshopping/addons/sms_ru/assets/js/jquery-2.1.1.min.js');
    $document->addStyleSheet('/components/com_jshopping/addons/sms_ru/assets/css/sms.ru.css');
	jimport('joomla.html.html.tabs');
	JHTML::_('behavior.tooltip');
}

if ($this->bootstrap) {
?>
<ul class="nav nav-tabs" id="tabsSmsRuSettings">
  <li class="active"><a data-toggle="tab" href="#tab1"><?php echo JText::_('SMS_RU_SETTINGS_GENERAL') ?></a></li>
  <li><a data-toggle="tab" href="#tab2"><?php echo JText::_('SMS_RU_SETTINGS_MESSAGE') ?></a></li>
  <li><a data-toggle="tab" href="#tab3"><?php echo JText::_('SMS_RU_SETTINGS_NEWMESSAGE') ?></a></li>
  <li><a data-toggle="tab" href="#tab4"><?php echo JText::_('SMS_RU_SETTINGS_STATUS') ?></a></li>
  <?php if($params['balance'] !== FALSE){?>
  	<li><a data-toggle="tab" href="#tab5"><?php echo JText::_('SMS_RU_SETTINGS_SENDCUSTOM') ?></a></li>
  <?php } ?>
  <li><a data-toggle="tab" href="#tab6"><?php echo JText::_('SMS_RU_SETTINGS_EXPORTUSERS') ?></a></li>
</ul>
<?php
	echo JHtml::_('bootstrap.startPane', 'tabsSmsRuSettings', array('active' => 'tab1'));
	echo JHtml::_('bootstrap.addPanel', 'tabsSmsRuSettings', 'tab1');
} else {
	echo JHtml::_('tabs.start', 'tabsSmsRuSettings', array('active' => 'tab1'));
	echo JHtml::_('tabs.panel', JText::_('SMS_RU_SETTINGS_GENERAL'), 'tab1');
}
$login_show = ($this->params->hardauth_enabled == 1) ? false : true;

?>
<div class="row-fluid">
	<div class="span9">
		<div class="control-group">
			<div class="control-label">
				<?php echo $form->getLabelByName("enable");?>
			</div>
			<div class="controls">
				<?php echo $form->getInputByName("enable");?>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label">
				<?php echo $form->getLabelByName("api_id");?>
			</div>
			<div class="controls">
				<?php echo $form->getInputByName("api_id");?>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label">
				<?php echo $form->getLabelByName("hardauth_enabled");?>
			</div>
			<div class="controls">
				<?php echo $form->getInputByName("hardauth_enabled");?>
			</div>
		</div>
        <div id="hardauth-logins"<?php if($login_show) echo ' style="display:none;"'?>>
    		<div class="control-group">
    			<div class="control-label">
    				<?php echo $form->getLabelByName("login");?>
    			</div>
    			<div class="controls">
    				<?php echo $form->getInputByName("login");?>
    			</div>
    		</div>
    		<div class="control-group">
    			<div class="control-label">
    				<?php echo $form->getLabelByName("password");?>
    			</div>
    			<div class="controls">
    				<?php echo $form->getInputByName("password");?>
    			</div>
    		</div>
        </div>
		<div class="control-group">
			<div class="control-label">
				<?php echo $form->getLabelByName("phones");?>
			</div>
			<div class="controls">
				<?php echo $form->getInputByName("phones");?>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label">
				<?php echo $form->getLabelByName("senders");?>
			</div>
			<div class="controls">
				<?php echo $form->getInputByName("senders");?>
			</div>
		</div>
	</div>
</div>
<script>
jQuery( 'input[name="params[hardauth_enabled]"]' ).on( "click", function() {
    if(jQuery(this).val() == '1'){
        jQuery( "#hardauth-logins" ).show( 400, function() {})
    }else{
        jQuery( "#hardauth-logins" ).hide( "fast" );
    }
});
</script>
<?php
if ($this->bootstrap) {
	echo JHtml::_('bootstrap.endPanel');
	echo JHtml::_('bootstrap.addPanel', 'tabsSmsRuSettings', 'tab2');
} else {
	echo JHtml::_('tabs.panel', JText::_('SMS_RU_SETTINGS_MESSAGE'), 'tab2');
}

include dirname(__FILE__).'/config-text.php';

if ($this->bootstrap) {
	echo JHtml::_('bootstrap.endPanel');
	echo JHtml::_('bootstrap.addPanel', 'tabsSmsRuSettings', 'tab3');
} else {
	echo JHtml::_('tabs.panel', JText::_('SMS_RU_SETTINGS_NEWMESSAGE'), 'tab3');
}

include dirname(__FILE__).'/config-newtext.php';

/** Status changed tab */
if ($this->bootstrap) {
	echo JHtml::_('bootstrap.endPanel');
	echo JHtml::_('bootstrap.addPanel', 'tabsSmsRuSettings', 'tab4');
} else {
	echo JHtml::_('tabs.panel', JText::_('SMS_RU_SETTINGS_STATUS'), 'tab4');
}

include dirname(__FILE__).'/config-status.php';
/** End status tab */

/** Custom message tab */
if($params['limit']!==FALSE){
	if ($this->bootstrap) {
		echo JHtml::_('bootstrap.endPanel');
		echo JHtml::_('bootstrap.addPanel', 'tabsSmsRuSettings', 'tab5');
	} else {
		echo JHtml::_('tabs.panel', JText::_('SMS_RU_SETTINGS_SENDCUSTOM'), 'tab5');
	}
	include dirname(__FILE__).'/config-sendcustom.php';
}
/** End custom message tab */

/** Export Users tab */
if ($this->bootstrap) {
	echo JHtml::_('bootstrap.endPanel');
	echo JHtml::_('bootstrap.addPanel', 'tabsSmsRuSettings', 'tab6');
} else {
	echo JHtml::_('tabs.panel', JText::_('SMS_RU_SETTINGS_EXPORTUSERS'), 'tab6');
}
include dirname(__FILE__).'/config-exportusers.php';
/** End export Users tab */

/** End tabs */
if ($this->bootstrap) {
	echo JHtml::_('bootstrap.endPanel');
	echo JHtml::_('bootstrap.endPane', 'tabsSmsRuSettings');
} else {
	echo JHtml::_('tabs.end');
}
?>