<?php
/**
 * SMS RU. Version 3.5.0
 * @package Joomla.JoomShopping
 * @author Alexandr Artamonov
 * @website http://w3strict.ru/
 * @email info@w3strict.ru
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
 
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');
 
jimport('joomla.form.formfield');
 
class JFormFieldPhonePriority extends JFormField {
 
    protected $type = 'phonepriority';

    // getLabel() left out
    
    public function getInput() {
        JHtml::_('jquery.ui', array('core', 'sortable'));
        $document = JFactory::getDocument();
        $document->addStyleSheet('//code.jquery.com/ui/1.11.1/themes/smoothness/jquery-ui.css');
        $document->addScriptDeclaration('
            jQuery( document ).ready(function() {
                jQuery( "#sortable" ).sortable({placeholder: "ui-state-highlight", opacity: 0.6, cursor: \'move\', update: function() {
                    var order = jQuery("#sortable" ).sortable("serialize"); 
                    jQuery( "#' . $this->id . '" ).val(order);
                } });
                jQuery( "#sortable" ).disableSelection();
            });
        ');
        parse_str(htmlspecialchars_decode($this->value), $val);
        $out = '<ul id="sortable">';
        $values_text = array(
            'phone' => JText::_('SMS_RU_TEXT_INSERT_PHONE'),
            'mobilphone' => JText::_('SMS_RU_TEXT_INSERT_MOBIL_PHONE'),
            'fax' => JText::_('SMS_RU_TEXT_INSERT_FAX'),
            'dphone' => JText::_('SMS_RU_TEXT_INSERT_PHONE_DELIVERY'),
            'dmobilphone' => JText::_('SMS_RU_TEXT_INSERT_MOBIL_PHONE_DELIVERY'),
            'dfax' => JText::_('SMS_RU_TEXT_INSERT_FAX_DELIVERY'),
        );
        foreach($val['phonepriority'] as $k => $v){
            $out .= '<li class="ui-state-default" id="phonepriority_'.$v.'">'.$values_text[$v].'</li>';
        }
        $out .= '</ul>';
        $out .= '<input type="hidden" value="'. htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') .'" name="' . $this->name . '" id="' . $this->id . '"/>';
        
        return $out;
    }
} 