<?php
/**
 * SMS RU. Version 1.0.0
 * @package Joomla.JoomShopping
 * @author Alexandr Artamonov
 * @website http://w3strict.ru/
 * @email info@w3strict.ru
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
 
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');
 
jimport('joomla.form.formfield');
 
class JFormFieldSenders extends JFormField {
 
    protected $type = 'Senders';
    
    public function getInput() {
    	
    	$options = array();
    	JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
    	$options[] = JHtml::_('select.option', 0, JText::_('SMS_RU_SENDERS_NONE'));
    	
    	// Get plugin params
    	$tableAddon = JTable::getInstance("Addon", "JShop");
    	$tableAddon->loadAlias("sms_ru");
    	$params = $tableAddon->getParams();
    	
    	if($params['hardauth_enabled'] && $params['login'] && $params['password']){
    		$ch = curl_init("http://sms.ru/auth/get_token");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		$token = curl_exec($ch);
    		curl_close($ch);
    		
    		$ch = curl_init("http://sms.ru/my/senders");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		$post_array = array(
    		
    			"login"		    =>	$params['login'],
            	"token"		    =>	$token
    		
    		);
    		if($params['api_id']){
    			$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
    		}else{
    			$post_array["sha512"] = hash("sha512",$params['password'].$token);
    		}
    		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
    		$body = curl_exec($ch);
    	}else{
    		$ch = curl_init("http://sms.ru/my/senders");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, array(
    			"api_id"		=>	$params['api_id']
    		));
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}
    	
    	$reply = array_filter(explode("\n", $body));
    	$code = array_shift($reply);
    	if ($code=="100") {
    		$senders = $reply;
    		foreach ($senders as $sender) {
    			$options[] = JHtml::_('select.option', $sender, $sender);
    		}
    	}
        $html[] = JHtml::_('select.genericlist', $options, $this->name, '', 'value', 'text', $this->value, $this->id);
        
        return implode($html);
    }
}