<?php
/**
 * SMS RU. Version 3.5.0
 * @package Joomla.JoomShopping
 * @author Alexandr Artamonov
 * @website http://w3strict.ru/
 * @email info@w3strict.ru
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

class plgjshoppingadminSMS_RU extends JPlugin {
    
    protected $users_file = "file.csv";
	
    function onAfterSaveAddons(&$params, &$post, &$row){
        if(!$this->__issmsruaddon($row->id)) return;
        if($post['exportusers']){
            
            // Generate select array
            $select = array('user_id', 'phone', 'mobil_phone', 'fax', 'd_phone', 'd_mobil_phone', 'd_fax', 'birthday');
            if($params['exportusers_firstname']) $select[] = 'f_name';
            if($params['exportusers_lastname']) $select[] = 'l_name';
            if($params['exportusers_mname']) $select[] = 'm_name';
            
            // Get a db connection.
            $db = JFactory::getDbo();
            
            // Create a new query object.
            $query = $db->getQuery(true);
            $query->select($db->quoteName($select));
            $query->from($db->quoteName('#__jshopping_users'));
            if(!$params['exportusers_without_birthday']){
                $query->where($db->quoteName('birthday') . ' != '. $db->quote('0000-00-00'));
            }
            
            // Reset the query using our newly populated query object.
            $db->setQuery($query);
             
            // Load the results as a list of stdClass objects (see later for more options on retrieving data).
            $results = $db->loadObjectList();
            
            $search_array = array('dphone', 'dmobilphone', 'dfax');
            $replace_array = array('d_phone', 'd_mobil_phone', 'd_fax');
            parse_str(str_replace($search_array, $replace_array, $params['exportusers_phonepriority']), $phonepriority);
            
            $out_array = array();
            $no_phone  = array();
            foreach($results as $i => $user){
                foreach($phonepriority['phonepriority'] as $phone){
                    if($this->__checkPhoneNumber($user->$phone)){
                        $out_array[$i]['phone'] = $user->$phone;
                        break;
                    }else{
                        $out_array[$i]['phone'] = '';
                    }
                }
                // Try export with wrong phone
                if(!$out_array[$i]['phone'] && $params['exportusers_withoutphone']){
                    foreach($phonepriority['phonepriority'] as $phone){
                        if($user->$phone){
                            $out_array[$i]['phone'] = $user->$phone;
                            break;
                        }else{
                            $out_array[$i]['phone'] = '';
                        }
                    }
                }
                // Delete array without phone
                if(!$out_array[$i]['phone']){
                    if(!$params['exportusers_withoutphone']){
                        unset($out_array[$i]);
                        $no_phone[] = $user->user_id;
                        continue;
                    }
                }
                
                if($params['exportusers_firstname'])$out_array[$i]['f_name'] = $user->f_name;
                if($params['exportusers_lastname']) $out_array[$i]['l_name'] = $user->l_name;
                if($params['exportusers_mname'])    $out_array[$i]['m_name'] = $user->m_name;
                $out_array[$i]['birthday'] = $user->birthday;
            }
            $fp = fopen(dirname(__FILE__) . "/" . $this->users_file, 'w');
            foreach ($out_array as $fields) {
                fputcsv($fp, $fields, ';');
            }
            fclose($fp);
            JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
            if(count($no_phone)){
                $user_without_phone_str = '';
                foreach($no_phone as $npi => $user_without_phone){
                    $user_without_phone_str .= '<a href="index.php?option=com_jshopping&controller=users&task=edit&user_id='.$user_without_phone.'">' . $user_without_phone . '</a>&nbsp;';
                    if($npi > 100){
                        $user_without_phone_str .= '...';
                        break;
                    }
                }
                JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_EXPORTUSERS_WPHONE_LIST').$user_without_phone_str, 'warning');
            }
            JFactory::getApplication()->enqueueMessage('<a 
                href="index.php?option=com_jshopping&controller=addons&task=edit'.
                '&downloadusers=true&id=' . $row->id . '">'.JText::_('SMS_RU_DOWNLOAD_USERS').'
            </a>');
        }
    }
    
    protected function __checkPhoneNumber($phone){
        if(preg_match('/^\+?([87](?!95[4-79]|99[08]|907|94[^0]|336|986)([348]\d|9[0-6789]|7[0247])\d{8}|[1246]\d{9,13}|68\d{7}|5[1-46-9]\d{8,12}|55[1-9]\d{9}|55[12]19\d{8}|500[56]\d{4}|5016\d{6}|5068\d{7}|502[45]\d{7}|5037\d{7}|50[4567]\d{8}|50855\d{4}|509[34]\d{7}|376\d{6}|855\d{8}|856\d{10}|85[0-4789]\d{8,10}|8[68]\d{10,11}|8[14]\d{10}|82\d{9,10}|852\d{8}|90\d{10}|96(0[79]|17[01]|13)\d{6}|96[23]\d{9}|964\d{10}|96(5[69]|89)\d{7}|96(65|77)\d{8}|92[023]\d{9}|91[1879]\d{9}|9[34]7\d{8}|959\d{7}|989\d{9}|97\d{8,12}|99[^4568]\d{7,11}|994\d{9}|9955\d{8}|996[57]\d{8}|9989\d{8}|380[34569]\d{8}|381\d{9}|385\d{8,9}|375[234]\d{8}|372\d{7,8}|37[0-4]\d{8}|37[6-9]\d{7,11}|30[69]\d{9}|34[67]\d{8}|3[12359]\d{8,12}|36\d{9}|38[1679]\d{8}|382\d{8,9}|46719\d{10})$/', $phone)) {
            return true;
        }else{
            return false;
        }
    }
    
	function onBeforeEditOrderStatus(&$view){
		$status_id = JRequest::getInt("status_id");
		JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
		$addon_row = JTable::getInstance('addon', 'jshop');
		$addon_row->loadAlias('sms_ru');
		$params = $addon_row->getParams();
		// print_r($params); 
		?>
		<script>
		jQuery( document ).ready(function() {
			jQuery('form[name="adminForm"]').append('<div class="col100"><fieldset class="adminform"><table class="admintable" width = "100%" ><tr><td class="key"><?php echo JText::_('SMS_RU_STATUS_CUSTOM_TEXT');?></td><td><textarea name="params[status_code_text][<?php echo $status_id; ?>]"><?php echo $params['status_code_text'][$status_id];?></textarea></td></tr></table></fieldset></div><div class="clr"></div>')
		});
		</script>
		<?php 
	}
	
	function onAfterSaveOrderStatus(&$order){
		$addon_row = JTable::getInstance('addon', 'jshop');
		$addon_row->loadAlias('sms_ru');
		$params = $addon_row->getParams();
		$post = JRequest::get('post');
		$status_id = $post['status_id'];
		
		$post = JRequest::get('post');
		$params['status_code_text'][$status_id] = $post['params']['status_code_text'][$status_id];
		if (!is_array($params)) $params = array();
		
		
		$addon_row->setParams($params);
		$addon_row->store();
	}
	
	
	function onAfterChangeOrderStatusAdmin(&$order_id, &$order_status, &$status_id, &$notify, &$comments, &$include, &$view_order){
		$addon_row = JTable::getInstance('addon', 'jshop');
		$addon_row->loadAlias('sms_ru');
		$params = $addon_row->getParams();
        
		if(!$params['enable']) return;
		if(!$params['enable_status']) return;
		if(!$params['forcibly_send'] && !$notify) return;
		
		$order = JTable::getInstance('order', 'jshop');
		$order->load($order_id);
		
		$phone_field = $params['send_user_new_order_status_phone_field'];
		$remove = array("+", "(", ")", " ", "-");
		$user_phone = str_replace($remove, "", $order->$phone_field);
		if(!$user_phone) return;
		
        $params_status_text = $params['status_text'];
        if($params['status_code_text'][$order_status]){
            $params_status_text = $params['status_code_text'][$order_status];
        }
        
		// Generate text
		$s = array('{sms_ru_newstatus}','{sms_ru_comment}',
				'{sms_ru_orderid}','{sms_ru_fname}','{sms_ru_lname}','{sms_ru_client_type}','{sms_ru_firma}','{sms_ru_code_firma}','{sms_ru_code_nds}','{sms_ru_email}',
				'{sms_ru_birthday}','{sms_ru_home}','{sms_ru_apartment}','{sms_ru_street}','{sms_ru_postcode}','{sms_ru_city}','{sms_ru_state}','{sms_ru_country}',
				'{sms_ru_phone}','{sms_ru_mobil_phone}','{sms_ru_fax}','{sms_ru_cost}','{sms_ru_d_fname}','{sms_ru_d_lname}','{sms_ru_d_firma}','{sms_ru_d_email}',
				'{sms_ru_d_birthday}','{sms_ru_d_home}','{sms_ru_d_apartment}','{sms_ru_d_street}','{sms_ru_d_postcode}','{sms_ru_d_city}','{sms_ru_d_state}',
				'{sms_ru_d_country}','{sms_ru_d_phone}','{sms_ru_d_mobil_phone}','{sms_ru_d_fax}');
		
		// Replace country code
		if(strstr($params_status_text, '{sms_ru_country}')){
			$row_country = JTable::getInstance('country', 'jshop');
			$row_country->load($order->country);
			$lang_tag = 'name_'.JFactory::getLanguage()->getTag();
			$country = $row_country->$lang_tag;
		}else{
			$country = $order->country;
		}
		
		// Format cost
		if(strstr($params_status_text, '{sms_ru_cost}')){
			$order_total = formatprice($order->order_total);
		}
		
		// Replace order status
		if(strstr($params_status_text, '{sms_ru_newstatus}')){
			$orderstatus_row = JTable::getInstance('orderstatus', 'jshop');
			$orderstatus = $orderstatus_row->getName($order_status);
		}else{
			$orderstatus = $order_status;
		}
		
		$r = array($orderstatus,$comments,$order->order_number,$order->f_name,$order->l_name,$order->client_type,$order->firma_name,$order->firma_code,$order->tax_number,$order->email,
				$order->birthday,$order->home,$order->apartment,$order->street,$order->zip,$order->city,$order->state,$country,
				$order->phone,$order->mobil_phone,$order->fax,$order_total,$order->d_f_name,$order->d_l_name,$order->d_firma_name,$order->d_email,
				$order->d_birthday,$order->d_home,$order->d_apartment,$order->d_street,$order->d_zip,$order->d_city,$order->d_state,
				$order->d_country,$order->d_phone,$order->d_mobil_phone,$order->d_fax);
		$text = str_replace($s, $r, $params_status_text);
		
		JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
		
		$ch = curl_init("http://sms.ru/sms/send");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $this->__getPostArray($order, $params, $user_phone, $text));
		$sms_send_result = curl_exec($ch);
		curl_close($ch);
		$code = explode("\n",$sms_send_result);
		$code = $code[0];
		if($code == 100) return;
		switch($code){
                case 200:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_200'),'warning');
                	break;
                case 201:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_201'),'warning');
                	break;
                case 202:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_202'),'warning');
                	break;
                case 203:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_203'),'warning');
                	break;
                case 204:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_204'),'warning');
                	break;
                case 205:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_205'),'warning');
                	break;
                case 206:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_206'),'warning');
                	break;
                case 207:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_207'),'warning');
                	break;
                case 208:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_208'),'warning');
                	break;
                case 209:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_209'),'warning');
                	break;
               case 210:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_210'),'warning');
                	break;
               case	211:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_211'),'warning');
                	break;
               case	212:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_212'),'warning');
                	break;
               case	220:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_220'),'warning');
                	break;
               case	230:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_230'),'warning');
                	break;
               case	300:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
                	break;
               case 301:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
                	break;
               case 302:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
                	break;
    	}
	}
	
	protected function __getPostArray($order, $params, $to, $text){
		
		$return = Array(
				"to"			=>	$to,
				"text"		    =>	$text,
				"partner_id"    =>  '62999',
				//'test'			=>  '1'
		);
		if($params['hardauth_enabled'] && $params['login'] && $params['password']){
			// Get token
			$ch = curl_init("http://sms.ru/auth/get_token");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_TIMEOUT, 30);
			$token = curl_exec($ch);
			curl_close($ch);
			// Generate array
			$return = array_merge(array(
					"login"		    =>	$params['login'],
					"token"		    =>	$token
			),$return);
		
			if($params['api_id']){
				$return["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
			}else{
				$return["sha512"] = hash("sha512",$params['password'].$token);
			}
		}else{
			$return = array_merge(array(
					"api_id"		=>	$params['api_id']
			),$return);
		}
		
		
		if($params['send_status_translit'] == 1){
			$return = array_merge(array("translit" => '1'),$return);
		}elseif($params['send_status_translit'] == '-1'){
			if(strlen($text) > 69 ){
				$return = array_merge(array("translit" => '1'),$return);
			}
		}
		
		if($params['senders']){
			$return = array_merge(array("from" => $params['senders']),$return);
		}
		
		return $return;
	}
	
	function onBeforeSaveAddons(&$array, &$array2){
		$row = JTable::getInstance('addon', 'jshop');
		$row->load($array2['id']);
		$para = $row->getParams();
		if(!$array['password']){
			$array['password'] = $para['password'];
		}
        $array['status_code_text'] = $para['status_code_text'];
        
        $jinput = JFactory::getApplication()->input;
       	if($jinput->get('send-custom-phones', FALSE,'raw') && $jinput->get('send-custom-text', FALSE,'raw')){
       		$translit = $jinput->get('send-custom-translit', '-1');
       		JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
       		
       		$sending_text = $jinput->get('send-custom-text', FALSE,'raw');
       		
       		$post = Array(
       				"to"			=>	$jinput->get('send-custom-phones', FALSE,'raw'),
       				"text"		    =>	$sending_text,
       				"partner_id"    =>  '62999'
       		);
       		if($para['hardauth_enabled'] && $para['login'] && $para['password']){
       			// Get token
       			$ch = curl_init("http://sms.ru/auth/get_token");
       			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
       			curl_setopt($ch, CURLOPT_TIMEOUT, 30);
       			$token = curl_exec($ch);
       			curl_close($ch);
       			// Generate array
       			$post = array_merge(array(
       					"login"		    =>	$para['login'],
       					"token"		    =>	$token
       			),$post);
       		
       			if($para['api_id']){
       				$post["sha512"] = hash("sha512",$para['password'].$token.$para['api_id']);
       			}else{
       				$post["sha512"] = hash("sha512",$para['password'].$token);
       			}
       		}else{
       			$post = array_merge(array(
       					"api_id"		=>	$para['api_id']
       			),$post);
       		}
       		
       		
       			if($translit == 1){
       				$post = array_merge(array("translit" => '1'),$post);
       			}elseif($translit == '-1'){
       				if(strlen($sending_text) > 69 ){
       					$post = array_merge(array("translit" => '1'),$post);
       				}
       			}
       		$from = $jinput->get('send-custom-text-senders', 0,'raw');
       		if($from){
       			$post["from"] = $from;
       		}
       		
       		$ch2 = curl_init("http://sms.ru/sms/send");
       		curl_setopt($ch2, CURLOPT_RETURNTRANSFER, 1);
       		curl_setopt($ch2, CURLOPT_TIMEOUT, 30);
       		curl_setopt($ch2, CURLOPT_POSTFIELDS, $post);
       		$answer = curl_exec($ch2);
       		curl_close($ch2);
       		
       		$code = explode("\n", $answer);
       		switch($code[0]){
       			case 100:
       				JFactory::getApplication()->enqueueMessage(
       				JText::sprintf( 'SMS_RU_SENDCUSTOM_SUCCESS_SENDING',
       				$jinput->get('send-custom-text', FALSE, 'raw'), $jinput->get('send-custom-phones', FALSE, 'raw') )
       				);
       				break;
       			case 200:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_200'),'warning');
       				break;
       			case 201:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_201'),'warning');
       				break;
       			case 202:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_202'),'warning');
       				break;
       			case 203:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_203'),'warning');
       				break;
       			case 204:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_204'),'warning');
       				break;
       			case 205:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_205'),'warning');
       				break;
       			case 206:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_206'),'warning');
       				break;
       			case 207:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_207'),'warning');
       				break;
       			case 208:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_208'),'warning');
       				break;
       			case 209:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_209'),'warning');
       				break;
       			case 210:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_210'),'warning');
       				break;
       			case	211:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_211'),'warning');
       				break;
       			case	212:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_212'),'warning');
       				break;
       			case	220:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_220'),'warning');
       				break;
       			case	230:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_230'),'warning');
       				break;
       			case	300:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
       				break;
       			case 301:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
       				break;
       			case 302:
       				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
       				break;
       		}
       	}
	}
    
    function onBeforeEditAddons(&$view) {
        if(!$this->__issmsruaddon($view->row->id)) return;
        if(JFactory::getApplication()->input->get('downloadusers') == true){
            if (file_exists(dirname(__FILE__) . "/" . $this->users_file)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename='.basename(dirname(__FILE__) . "/" . $this->users_file));
                header('Content-Transfer-Encoding: binary');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize(dirname(__FILE__) . "/" . $this->users_file));
                ob_clean();
                flush();
                readfile(dirname(__FILE__) . "/" . $this->users_file);
                jexit();
            }
        }
        $params = $view->params;
        JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
        if($params['api_id'] or ($params['login'] && $params['password'])){
        	
            if($params['hardauth_enabled'] && !($params['login'] && $params['password'])){
                JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_NOT_SET_LOGIN_PASSWORD'),'warning');
            	$view->params['balance'] = FALSE;
            	$view->params['limit'] = FALSE;
            	
            }elseif($params['hardauth_enabled'] && ($params['login'] && $params['password'])){
            	
            	if($this->__checkAuth($params)){
            		$view->params['balance'] = $this->__getBalance($params);
            		$view->params['limit'] = $this->__getLimit($params);
            	}else{
            		$view->params['balance'] = FALSE;
            		$view->params['limit'] = FALSE;
            	}
            }else{
	        	$view->params['balance'] = $this->__getBalance($params);
	        	$view->params['limit'] = $this->__getLimit($params);
	        }
        }else{
            $view->params['balance'] = FALSE;
            $view->params['limit'] = FALSE;
        }
        $view->params['password'] = '';
	}
    
    
    private function __checkAuth($params){
        // Get security token
        $ch = curl_init("http://sms.ru/auth/get_token");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $token = curl_exec($ch);
        curl_close($ch);
        // Check auth
        $ch = curl_init("http://sms.ru/auth/check");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $post_array = array(
        	"login"		=>	$params['login'],
        	"token"		=>	$token
        );
        if($params['api_id']){
        	$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
        }else{
        	$post_array["sha512"] = hash("sha512",$params['password'].$token);
        }
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
        $body = (int)curl_exec($ch);
        curl_close($ch);
        if ($body===100) {
        	return TRUE;
        } else {
            switch($body){
                case 300:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
                	break;
               case 301:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
                	break;
               case 302:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
                	break;
            }
            return FALSE;
        }
    }
    
    
    private function __getBalance($params){
    	if($params['hardauth_enabled'] && ($params['login'] && $params['password'])){
    		// Get security token
    		$ch = curl_init("http://sms.ru/auth/get_token");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		$token = curl_exec($ch);
    		curl_close($ch);
    		// Check auth
    		$ch = curl_init("http://sms.ru/my/balance");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            $post_array = array(
            	"login"		=>	$params['login'],
            	"token"		=>	$token
            );
            if($params['api_id']){
            	$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
            }else{
            	$post_array["sha512"] = hash("sha512",$params['password'].$token);
            }
    		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}elseif ($params['api_id']){
    		$ch = curl_init("http://sms.ru/my/balance");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, array(
    			"api_id"		=>	$params['api_id']
    		));
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}else{
    		JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_NO_BALANCE_LOGIN_DATA'),'warning');
    		return FALSE;
    	}
    	list($code,$balance) = explode("\n", $body);
    	if ($code=="100") {
    		return $balance;
    	} else {
    	switch($code){
                case 200:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_200'),'warning');
                	break;
               case 210:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_210'),'warning');
                	break;
               case	211:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_211'),'warning');
                	break;
               case	220:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_220'),'warning');
                	break;
               case	300:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
                	break;
               case 301:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
                	break;
               case 302:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
                	break;
            }
    	}
    	return FALSE;
    }
    
    private function __getLimit($params){
    	if($params['hardauth_enabled'] && ($params['login'] && $params['password'])){
    		// Get security token
    		$ch = curl_init("http://sms.ru/auth/get_token");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		$token = curl_exec($ch);
    		curl_close($ch);
    		// Check auth
    		$ch = curl_init("http://sms.ru/my/limit");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            $post_array = array(
            	"login"		=>	$params['login'],
            	"token"		=>	$token
            );
            if($params['api_id']){
            	$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
            }else{
            	$post_array["sha512"] = hash("sha512",$params['password'].$token);
            }
    		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}elseif ($params['api_id']){
    		$ch = curl_init("http://sms.ru/my/limit");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, array(
    		"api_id"		=>	$params['api_id']
    		));
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}else{
    		JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_NO_LIMIT_LOGIN_DATA'),'warning');
    		return FALSE;
    	}
    	
    	list($code,$limit,$today) = explode("\n", $body);
    	if ($code=="100") {
    		return "$today / $limit";
    	} else {
    		switch($code){
    			case 200:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_200'),'warning');
    				break;
    			case 210:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_210'),'warning');
    				break;
    			case 211:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_211'),'warning');
    				break;
    			case 220:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_220'),'warning');
    				break;
    			case 300:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
    				break;
    			case 301:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
    				break;
    			case 302:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
    				break;
    		}
    	}
    	return FALSE;
    }
    
    protected function __issmsruaddon($id){
        $addon_row = JTable::getInstance('addon', 'jshop');
		$addon_row->loadAlias('sms_ru');
        $addon_id = $addon_row->get('id');
        return ($addon_id == $id) ? true : false;
    }
}