<?php
/**
 * SMS RU. Version 1.0.1
 * @package Joomla.JoomShopping
 * @author Alexandr Artamonov
 * @website http://w3strict.ru/
 * @email info@w3strict.ru
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

class plgjshoppingadminSMS_RU extends JPlugin {
	
	function onBeforeSaveAddons(&$array, &$array2){
		if(!$array['password']){
			$row = JTable::getInstance('addon', 'jshop');
			$row->load($array2['id']);
			$params = $row->getParams();
            $array['password'] = $params['password'];
		}
	}
    
    function onBeforeEditAddons(&$view) {
        $params = $view->params;
        JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
        if($params['api_id'] or ($params['login'] && $params['password'])){
            if($params['hardauth_enabled'] && !($params['login'] && $params['password'])){
                JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_NOT_SET_LOGIN_PASSWORD'),'warning');
            	$view->params['balance'] = FALSE;
            	$view->params['limit'] = FALSE;
            }elseif($params['hardauth_enabled'] && ($params['login'] && $params['password'])){
            	if($this->__checkAuth($params)){
            		$view->params['balance'] = $this->__getBalance($params);
            		$view->params['limit'] = $this->__getLimit($params);
            	}else{
            		$view->params['balance'] = FALSE;
            		$view->params['limit'] = FALSE;
            	}
            }else{
	        	$view->params['balance'] = $this->__getBalance($params);
	        	$view->params['limit'] = $this->__getLimit($params);
	        }
        }
        $view->params['password'] = '';
	}
    
    
    private function __checkAuth($params){
        // Get security token
        $ch = curl_init("http://sms.ru/auth/get_token");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $token = curl_exec($ch);
        curl_close($ch);
        // Check auth
        $ch = curl_init("http://sms.ru/auth/check");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $post_array = array(
        	"login"		=>	$params['login'],
        	"token"		=>	$token
        );
        if($params['api_id']){
        	$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
        }else{
        	$post_array["sha512"] = hash("sha512",$params['password'].$token);
        }
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
        $body = (int)curl_exec($ch);
        curl_close($ch);
        if ($body===100) {
        	return TRUE;
        } else {
            switch($body){
                case 300:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
                	break;
               case 301:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
                	break;
               case 302:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
                	break;
            }
            return FALSE;
        }
    }
    
    
    private function __getBalance($params){
    	if($params['hardauth_enabled'] && ($params['login'] && $params['password'])){
    		// Get security token
    		$ch = curl_init("http://sms.ru/auth/get_token");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		$token = curl_exec($ch);
    		curl_close($ch);
    		// Check auth
    		$ch = curl_init("http://sms.ru/my/balance");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            $post_array = array(
            	"login"		=>	$params['login'],
            	"token"		=>	$token
            );
            if($params['api_id']){
            	$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
            }else{
            	$post_array["sha512"] = hash("sha512",$params['password'].$token);
            }
    		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}elseif ($params['api_id']){
    		$ch = curl_init("http://sms.ru/my/balance");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, array(
    			"api_id"		=>	$params['api_id']
    		));
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}else{
    		JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_NO_BALANCE_LOGIN_DATA'),'warning');
    		return FALSE;
    	}
    	list($code,$balance) = explode("\n", $body);
    	if ($code=="100") {
    		return $balance;
    	} else {
    	switch($code){
                case 200:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_200'),'warning');
                	break;
               case 210:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_210'),'warning');
                	break;
               case	211:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_211'),'warning');
                	break;
               case	220:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_220'),'warning');
                	break;
               case	300:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
                	break;
               case 301:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
                	break;
               case 302:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
                	break;
            }
    	}
    	return FALSE;
    }
    
    private function __getLimit($params){
    	if($params['hardauth_enabled'] && ($params['login'] && $params['password'])){
    		// Get security token
    		$ch = curl_init("http://sms.ru/auth/get_token");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		$token = curl_exec($ch);
    		curl_close($ch);
    		// Check auth
    		$ch = curl_init("http://sms.ru/my/limit");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            $post_array = array(
            	"login"		=>	$params['login'],
            	"token"		=>	$token
            );
            if($params['api_id']){
            	$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
            }else{
            	$post_array["sha512"] = hash("sha512",$params['password'].$token);
            }
    		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}elseif ($params['api_id']){
    		$ch = curl_init("http://sms.ru/my/limit");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, array(
    		"api_id"		=>	$params['api_id']
    		));
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}else{
    		JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_NO_LIMIT_LOGIN_DATA'),'warning');
    		return FALSE;
    	}
    	
    	list($code,$limit,$today) = explode("\n", $body);
    	if ($code=="100") {
    		return "$today / $limit";
    	} else {
    		switch($code){
    			case 200:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_200'),'warning');
    				break;
    			case 210:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_210'),'warning');
    				break;
    			case 211:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_211'),'warning');
    				break;
    			case 220:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_220'),'warning');
    				break;
    			case 300:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
    				break;
    			case 301:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
    				break;
    			case 302:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
    				break;
    		}
    	}
    	return FALSE;
    }
}