<?php
/**
 * SMS RU. Version 1.0.0
 * @package Joomla.JoomShopping
 * @author Alexandr Artamonov
 * @website http://w3strict.ru/
 * @email info@w3strict.ru
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined("_JEXEC") or die("Restricted access");
jimport('joomla.application.component.controller');

class plgJShoppingCheckoutSMS_RU extends JPlugin
{
    public function onAfterDisplayCheckoutFinish(&$text, &$order, &$pm_method){
        // Get plugin params
        $tableAddon = JTable::getInstance("Addon", "JShop");
		$tableAddon->loadAlias("sms_ru");
		$params = $tableAddon->getParams();
        
        if(!$params['enable']) return;
        
        $ch = curl_init("http://sms.ru/sms/send");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $this->__getPostArray($order, $params));
        $body = curl_exec($ch);
        curl_close($ch);
    }
    
    /**
     * Create the post array
     * 
     * @param $order  Object with order data
     * @param $params Plugin parameters
     * 
     * @return Array
     */
    protected function __getPostArray($order, $params){
        $return = Array(
            	"to"			=>	$params['phones'],
            	"text"		    =>	$this->__getSendingText($order, $params),
                "partner_id"    =>  '62999'
        );
        if($params['hardauth_enabled'] && $params['login'] && $params['password']){
            // Get token
            $ch = curl_init("http://sms.ru/auth/get_token");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            $token = curl_exec($ch);
            curl_close($ch);
            // Generate array
            $return = array_merge(array(
            	"login"		    =>	$params['login'],
            	"token"		    =>	$token
            ),$return);
            
	        if($params['api_id']){
	        	$return["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
	        }else{
	        	$return["sha512"] = hash("sha512",$params['password'].$token);
	        }
        }else{
            $return = array_merge(array(
            	"api_id"		=>	$params['api_id']
            ),$return);
        }
        
        if($params['translit']){
        	$return = array_merge(array("translit" => '1'),$return);
        }
        
        if($params['senders'] != 0){
        	$return = array_merge(array("from" => $params['senders']),$return);
        }
        return $return;
    }
    /**
     * Creates the final version of the message
     * 
     * @param $order  Object with order data
     * @param $params Plugin parameters
     * 
     * @return string  Message text
     */
    protected function __getSendingText($order, $params){
        $s = array('{sms_ru_fname}','{sms_ru_lname}','{sms_ru_client_type}','{sms_ru_firma}','{sms_ru_code_firma}','{sms_ru_code_nds}','{sms_ru_email}',
            '{sms_ru_birthday}','{sms_ru_home}','{sms_ru_apartment}','{sms_ru_street}','{sms_ru_postcode}','{sms_ru_city}','{sms_ru_state}','{sms_ru_country}',
            '{sms_ru_phone}','{sms_ru_mobil_phone}','{sms_ru_fax}','{sms_ru_cost}','{sms_ru_d_fname}','{sms_ru_d_lname}','{sms_ru_d_firma}','{sms_ru_d_email}',
            '{sms_ru_d_birthday}','{sms_ru_d_home}','{sms_ru_d_apartment}','{sms_ru_d_street}','{sms_ru_d_postcode}','{sms_ru_d_city}','{sms_ru_d_state}',
            '{sms_ru_d_country}','{sms_ru_d_phone}','{sms_ru_d_mobil_phone}','{sms_ru_d_fax}');
        
        // Replace country code
        if(strripos($params['sms_text'], '{sms_ru_country}')){
	        $row = JTable::getInstance('country', 'jshop');
	        $row->load($order->country);
	        $lang_tag = 'name_'.JFactory::getLanguage()->getTag();
        	$country = $row->$lang_tag;
        }else{
        	$country = $order->country;
        }
        
        $r = array($order->f_name,$order->l_name,$order->client_type,$order->firma_name,$order->firma_code,$order->tax_number,$order->email,
            $order->birthday,$order->home,$order->apartment,$order->street,$order->zip,$order->city,$order->state,$country,
            $order->phone,$order->mobil_phone,$order->fax,$order->order_total,$order->d_f_name,$order->d_l_name,$order->d_firma_name,$order->d_email,
            $order->d_birthday,$order->d_home,$order->d_apartment,$order->d_street,$order->d_zip,$order->d_city,$order->d_state,
            $order->d_country,$order->d_phone,$order->d_mobil_phone,$order->d_fax);
        return str_replace($s, $r, $params['sms_text']);
    }
}