<?php
/**
 * SMS RU. Version 2.0.0
 * @package Joomla.JoomShopping
 * @author Alexandr Artamonov
 * @website http://w3strict.ru/
 * @email info@w3strict.ru
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

class plgjshoppingadminSMS_RU extends JPlugin {
	
	function onAfterChangeOrderStatusAdmin(&$order_id, &$order_status, &$status_id, &$notify, &$comments, &$include, &$view_order){
		$addon_row = JTable::getInstance('addon', 'jshop');
		$addon_row->loadAlias('sms_ru');
		$params = $addon_row->getParams();
		
		if(!$params['enable']) return;
		if(!$params['enable_status']) return;
		if(!$params['forcibly_send'] && !$notify) return;
		
		$order = JTable::getInstance('order', 'jshop');
		$order->load($order_id);
		
		$phone_field = $params['send_user_new_order_status_phone_field'];
		$remove = array("+", "(", ")", " ", "-");
		$user_phone = str_replace($remove, "", $order->$phone_field);
		if(!$user_phone) return;
		
		// Generate text
		$s = array('{sms_ru_newstatus}','{sms_ru_comment}',
				'{sms_ru_orderid}','{sms_ru_fname}','{sms_ru_lname}','{sms_ru_client_type}','{sms_ru_firma}','{sms_ru_code_firma}','{sms_ru_code_nds}','{sms_ru_email}',
				'{sms_ru_birthday}','{sms_ru_home}','{sms_ru_apartment}','{sms_ru_street}','{sms_ru_postcode}','{sms_ru_city}','{sms_ru_state}','{sms_ru_country}',
				'{sms_ru_phone}','{sms_ru_mobil_phone}','{sms_ru_fax}','{sms_ru_cost}','{sms_ru_d_fname}','{sms_ru_d_lname}','{sms_ru_d_firma}','{sms_ru_d_email}',
				'{sms_ru_d_birthday}','{sms_ru_d_home}','{sms_ru_d_apartment}','{sms_ru_d_street}','{sms_ru_d_postcode}','{sms_ru_d_city}','{sms_ru_d_state}',
				'{sms_ru_d_country}','{sms_ru_d_phone}','{sms_ru_d_mobil_phone}','{sms_ru_d_fax}');
		
		// Replace country code
		if(strstr($params['status_text'], '{sms_ru_country}')){
			$row_country = JTable::getInstance('country', 'jshop');
			$row_country->load($order->country);
			$lang_tag = 'name_'.JFactory::getLanguage()->getTag();
			$country = $row_country->$lang_tag;
		}else{
			$country = $order->country;
		}
		
		// Replace order status
		if(strstr($params['status_text'], '{sms_ru_newstatus}')){
			$orderstatus_row = JTable::getInstance('orderstatus', 'jshop');
			$orderstatus = $orderstatus_row->getName($order_status);
		}else{
			$orderstatus = $order_status;
		}
		
		$r = array($orderstatus,$comments,$order->order_id,$order->f_name,$order->l_name,$order->client_type,$order->firma_name,$order->firma_code,$order->tax_number,$order->email,
				$order->birthday,$order->home,$order->apartment,$order->street,$order->zip,$order->city,$order->state,$country,
				$order->phone,$order->mobil_phone,$order->fax,$order->order_total,$order->d_f_name,$order->d_l_name,$order->d_firma_name,$order->d_email,
				$order->d_birthday,$order->d_home,$order->d_apartment,$order->d_street,$order->d_zip,$order->d_city,$order->d_state,
				$order->d_country,$order->d_phone,$order->d_mobil_phone,$order->d_fax);
		$text = str_replace($s, $r, $params['status_text']);
		
		JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
		
		$ch = curl_init("http://sms.ru/sms/send");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $this->__getPostArray($order, $params, $user_phone, $text));
		$sms_send_result = curl_exec($ch);
		curl_close($ch);
		$code = explode("\n",$sms_send_result);
		$code = $code[0];
		if($code == 100) return;
		switch($code){
                case 200:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_200'),'warning');
                	break;
                case 201:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_201'),'warning');
                	break;
                case 202:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_202'),'warning');
                	break;
                case 203:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_203'),'warning');
                	break;
                case 204:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_204'),'warning');
                	break;
                case 205:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_205'),'warning');
                	break;
                case 206:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_206'),'warning');
                	break;
                case 207:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_207'),'warning');
                	break;
                case 208:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_208'),'warning');
                	break;
                case 209:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_209'),'warning');
                	break;
               case 210:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_210'),'warning');
                	break;
               case	211:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_211'),'warning');
                	break;
               case	212:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_212'),'warning');
                	break;
               case	220:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_220'),'warning');
                	break;
               case	230:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_230'),'warning');
                	break;
               case	300:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
                	break;
               case 301:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
                	break;
               case 302:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
                	break;
    	}
	}
	
	protected function __getPostArray($order, $params, $to, $text){
		
		$return = Array(
				"to"			=>	$to,
				"text"		    =>	$text,
				"partner_id"    =>  '62999',
				//'test'			=>  '1'
		);
		if($params['hardauth_enabled'] && $params['login'] && $params['password']){
			// Get token
			$ch = curl_init("http://sms.ru/auth/get_token");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_TIMEOUT, 30);
			$token = curl_exec($ch);
			curl_close($ch);
			// Generate array
			$return = array_merge(array(
					"login"		    =>	$params['login'],
					"token"		    =>	$token
			),$return);
		
			if($params['api_id']){
				$return["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
			}else{
				$return["sha512"] = hash("sha512",$params['password'].$token);
			}
		}else{
			$return = array_merge(array(
					"api_id"		=>	$params['api_id']
			),$return);
		}
		
		
		if($params['send_status_translit'] == 1){
			$return = array_merge(array("translit" => '1'),$return);
		}elseif($params['send_status_translit'] == '-1'){
			if(strlen($text) > 69 ){
				$return = array_merge(array("translit" => '1'),$return);
			}
		}
		
		if($params['senders'] != 0){
			$return = array_merge(array("from" => $params['senders']),$return);
		}
		
		return $return;
	}
	
	function onBeforeSaveAddons(&$array, &$array2){
		if(!$array['password']){
			$row = JTable::getInstance('addon', 'jshop');
			$row->load($array2['id']);
			$para = $row->getParams();
			$array['password'] = $para['password'];
		}
	}
    
    function onBeforeEditAddons(&$view) {
        $params = $view->params;
        JFactory::getLanguage()->load('sms_ru', JPATH_SITE.'/components/com_jshopping/addons/sms_ru');
        if($params['api_id'] or ($params['login'] && $params['password'])){
            if($params['hardauth_enabled'] && !($params['login'] && $params['password'])){
                JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_NOT_SET_LOGIN_PASSWORD'),'warning');
            	$view->params['balance'] = FALSE;
            	$view->params['limit'] = FALSE;
            }elseif($params['hardauth_enabled'] && ($params['login'] && $params['password'])){
            	if($this->__checkAuth($params)){
            		$view->params['balance'] = $this->__getBalance($params);
            		$view->params['limit'] = $this->__getLimit($params);
            	}else{
            		$view->params['balance'] = FALSE;
            		$view->params['limit'] = FALSE;
            	}
            }else{
	        	$view->params['balance'] = $this->__getBalance($params);
	        	$view->params['limit'] = $this->__getLimit($params);
	        }
        }
        $view->params['password'] = '';
	}
    
    
    private function __checkAuth($params){
        // Get security token
        $ch = curl_init("http://sms.ru/auth/get_token");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $token = curl_exec($ch);
        curl_close($ch);
        // Check auth
        $ch = curl_init("http://sms.ru/auth/check");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $post_array = array(
        	"login"		=>	$params['login'],
        	"token"		=>	$token
        );
        if($params['api_id']){
        	$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
        }else{
        	$post_array["sha512"] = hash("sha512",$params['password'].$token);
        }
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
        $body = (int)curl_exec($ch);
        curl_close($ch);
        if ($body===100) {
        	return TRUE;
        } else {
            switch($body){
                case 300:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
                	break;
               case 301:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
                	break;
               case 302:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
                	break;
            }
            return FALSE;
        }
    }
    
    
    private function __getBalance($params){
    	if($params['hardauth_enabled'] && ($params['login'] && $params['password'])){
    		// Get security token
    		$ch = curl_init("http://sms.ru/auth/get_token");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		$token = curl_exec($ch);
    		curl_close($ch);
    		// Check auth
    		$ch = curl_init("http://sms.ru/my/balance");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            $post_array = array(
            	"login"		=>	$params['login'],
            	"token"		=>	$token
            );
            if($params['api_id']){
            	$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
            }else{
            	$post_array["sha512"] = hash("sha512",$params['password'].$token);
            }
    		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}elseif ($params['api_id']){
    		$ch = curl_init("http://sms.ru/my/balance");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, array(
    			"api_id"		=>	$params['api_id']
    		));
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}else{
    		JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_NO_BALANCE_LOGIN_DATA'),'warning');
    		return FALSE;
    	}
    	list($code,$balance) = explode("\n", $body);
    	if ($code=="100") {
    		return $balance;
    	} else {
    	switch($code){
                case 200:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_200'),'warning');
                	break;
               case 210:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_210'),'warning');
                	break;
               case	211:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_211'),'warning');
                	break;
               case	220:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_220'),'warning');
                	break;
               case	300:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
                	break;
               case 301:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
                	break;
               case 302:
                	JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
                	break;
            }
    	}
    	return FALSE;
    }
    
    private function __getLimit($params){
    	if($params['hardauth_enabled'] && ($params['login'] && $params['password'])){
    		// Get security token
    		$ch = curl_init("http://sms.ru/auth/get_token");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		$token = curl_exec($ch);
    		curl_close($ch);
    		// Check auth
    		$ch = curl_init("http://sms.ru/my/limit");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            $post_array = array(
            	"login"		=>	$params['login'],
            	"token"		=>	$token
            );
            if($params['api_id']){
            	$post_array["sha512"] = hash("sha512",$params['password'].$token.$params['api_id']);
            }else{
            	$post_array["sha512"] = hash("sha512",$params['password'].$token);
            }
    		curl_setopt($ch, CURLOPT_POSTFIELDS, $post_array);
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}elseif ($params['api_id']){
    		$ch = curl_init("http://sms.ru/my/limit");
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, array(
    		"api_id"		=>	$params['api_id']
    		));
    		$body = curl_exec($ch);
    		curl_close($ch);
    	}else{
    		JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_NO_LIMIT_LOGIN_DATA'),'warning');
    		return FALSE;
    	}
    	
    	list($code,$limit,$today) = explode("\n", $body);
    	if ($code=="100") {
    		return "$today / $limit";
    	} else {
    		switch($code){
    			case 200:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_200'),'warning');
    				break;
    			case 210:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_210'),'warning');
    				break;
    			case 211:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_211'),'warning');
    				break;
    			case 220:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_220'),'warning');
    				break;
    			case 300:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_300'),'warning');
    				break;
    			case 301:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_301'),'warning');
    				break;
    			case 302:
    				JFactory::getApplication()->enqueueMessage(JText::_('SMS_RU_ALERTS_AUTH_302'),'warning');
    				break;
    		}
    	}
    	return FALSE;
    }
}