<?php

defined ('_JEXEC') or die('Restricted access');

/**
 * LiqPay official payment plugin
 * 
 * @version $Id: liqpay.php,v 1.0.0 2013/06/29 08:20 ei
 *
 * @author Aleksandr Artamonov
 * @site http://w3strict.ru/
 * @package VirtueMart
 * @subpackage payment
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://virtuemart.net
 */
if (!class_exists ('vmPSPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

class plgVmPaymentLiqPay extends vmPSPlugin {
    
    public static $_this = FALSE;
    
    /**
     * Constructor
     */
	function __construct (& $subject, $config) {

		parent::__construct ($subject, $config);
		// 		vmdebug('Plugin stuff',$subject, $config);
		$this->_loggable = TRUE;
		$this->tableFields = array_keys ($this->getTableSQLFields ());
		$this->_tablepkey = 'id';
		$this->_tableId = 'id';
		$varsToPush = $this->getVarsToPush ();
		$this->setConfigParameterable ($this->_configTableFieldName, $varsToPush);

	}

	/**
	 * Create the table for this plugin if it does not yet exist.
	 *
	 * @author Aleksandr Artamonov
     * @site http://w3strict.ru/
	 */
	public function getVmPluginCreateTableSQL () {

		return $this->createTableSQL ('Payment LiqPay Table');
	}

	/**
	 * Fields to create the payment table
	 *
	 * @return string SQL Fileds
     * 
	 * @author Aleksandr Artamonov
     * @site http://w3strict.ru/
	 */
	function getTableSQLFields () {

		$SQLfields = array(
			'id'                          => 'int(1) UNSIGNED NOT NULL AUTO_INCREMENT',
			'virtuemart_order_id'         => 'int(1) UNSIGNED',
			'order_number'                => 'char(64)',
			'virtuemart_paymentmethod_id' => 'mediumint(1) UNSIGNED',
			'payment_name'                => 'varchar(5000)',
			'payment_order_total'         => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
			'payment_currency'            => 'char(3)',
			'cost_per_transaction'        => 'decimal(10,2)',
			'cost_percent_total'          => 'decimal(10,2)',
			'tax_id'                      => 'smallint(1)'
		);

		return $SQLfields;
	}

	/**
	 *
	 *
	 * @author Aleksandr Artamonov
     * @site http://w3strict.ru/
	 */
	function plgVmConfirmedOrder ($cart, $order) {

		if (!($method = $this->getVmPluginMethod ($order['details']['BT']->virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}
		// 		$params = new JParameter($payment->payment_params);
		$lang = JFactory::getLanguage ();
		$filename = 'com_virtuemart';
		$lang->load ($filename, JPATH_ADMINISTRATOR);
    	$vendorId = 0;
        
		if (!class_exists ('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		$this->getPaymentCurrency ($method, TRUE);

		// END printing out HTML Form code (Payment Extra Info)
		$q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' . $method->payment_currency . '" ';
		$db = JFactory::getDBO ();
		$db->setQuery ($q);
		$currency_code_3 = $db->loadResult ();
		$paymentCurrency = CurrencyDisplay::getInstance ($method->payment_currency);
		$totalInPaymentCurrency = round ($paymentCurrency->convertCurrencyTo ($method->payment_currency, $order['details']['BT']->order_total, FALSE), 2);
		$cd = CurrencyDisplay::getInstance ($cart->pricesCurrency);

		$dbValues['payment_name'] = $this->renderPluginName ($method) . '<br />' . $method->payment_info;
		$dbValues['order_number'] = $order['details']['BT']->order_number;
		$dbValues['virtuemart_paymentmethod_id'] = $order['details']['BT']->virtuemart_paymentmethod_id;
		$dbValues['cost_per_transaction'] = $method->cost_per_transaction;
		$dbValues['cost_percent_total'] = $method->cost_percent_total;
		$dbValues['payment_currency'] = $currency_code_3;
		$dbValues['payment_order_total'] = $totalInPaymentCurrency;
		$dbValues['tax_id'] = $method->tax_id;
		$this->storePSPluginInternalData ($dbValues);

		$html = '<table class="vmorder-done">' . "\n";
		$html .= $this->getHtmlRow ('LIQPAY_PAYMENTINFO', $dbValues['payment_name'], 'class="vmorder-done-payinfo"');
		if (!empty($payment_info)) {
			$lang = JFactory::getLanguage ();
			if ($lang->hasKey ($method->payment_info)) {
				$payment_info = JText::_ ($method->payment_info);
			} else {
				$payment_info = $method->payment_info;
			}
			$html .= $this->getHtmlRow ('LIQPAY_PAYMENTINFO', $payment_info, 'class="vmorder-done-payinfo"');
		}
		if (!class_exists ('VirtueMartModelCurrency')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');
		}
		$currency = CurrencyDisplay::getInstance ('', $order['details']['BT']->virtuemart_vendor_id);
		$html .= $this->getHtmlRow ('LIQPAY_ORDERNUMBER', $order['details']['BT']->order_number, "vmorder-done-nr");
		$html .= $this->getHtmlRow ('LIQPAY_AMOUNT', $currency->priceDisplay ($order['details']['BT']->order_total), "vmorder-done-amount");
		//$html .= $this->getHtmlRow('LIQPAY_INFO', $method->payment_info);
		//$html .= $this->getHtmlRow('LIQPAY_AMOUNT', $totalInPaymentCurrency.' '.$currency_code_3);
		$html .= '</table>' . "\n";
        
        // Get variables
        $result_url = JROUTE::_(JURI::root () . 'index.php?option=com_virtuemart&amp;view=pluginresponse&amp;task=pluginresponsereceived&amp;on=' . $order['details']['BT']->order_number . '&amp;pmi=' . $order['details']['BT']->virtuemart_paymentmethod_id . '&amp;Itemid=' . JRequest::getInt ('Itemid'));
        $server_url = JROUTE::_(JURI::root () . 'index.php?option=com_virtuemart&amp;view=pluginresponse&amp;task=pluginnotification&amp;tmpl=component');
        $merchant_id = $method->merchant_id;
        $order_number = $order['details']['BT']->order_number;
        $default_phone = $order['details']['BT']->phone1;
        $merc_sign = $method->merc_sign;
        $currency_xml = ($currency_code_3 == 'RUB')? 'RUR' : $currency_code_3;
        //Create description variable
        $oicount = count($order['items']);
        if($oicount === 1){
            $description = $order['items'][0]->order_item_name.'('.$order['items'][0]->product_quantity.')';
        }else{
            $description = '';
            foreach($order['items'] as $oik => $oiv){
                $description .= $oiv->order_item_name.'('.$oiv->product_quantity.')';
                if($oik != ($oicount-1)){
                    $description .= ', ';
                }else{
                    $description .= '.';
                }
            }
        }
        // Creating liqpay XML request
        $xml="<request>
    		<version>1.2</version>
    		<result_url>$result_url</result_url>
    		<server_url>$server_url</server_url>
    		<merchant_id>$merchant_id</merchant_id>
    		<order_id>$order_number</order_id>
    		<amount>$totalInPaymentCurrency</amount>
    		<currency>$currency_xml</currency>
    		<description>$description</description>
    		<default_phone>$default_phone</default_phone>
    		<pay_way>card, liqpay, delayed</pay_way>
            <exp_time>36</exp_time>
		</request>";
        
        // Creating form value
    	$xml_encoded = base64_encode($xml); 
    	$lqsignature = base64_encode(sha1($merc_sign.$xml.$merc_sign,1));
        
        $html .= "<form action='https://www.liqpay.com/?do=clickNbuy' method='POST'>";
        $html .= "<input type='hidden' name='operation_xml' value='$xml_encoded' />";
        $html .= "<input type='hidden' name='signature' value='$lqsignature' />";
        $html .= "<input type='submit' value='".JText::_('VMPAYMENT_LIQPAY_SUBMITBUTTON')."'/>";
        $html .= "</form>";
        
		$modelOrder = VmModel::getModel ('orders');
		$order['order_status'] = $this->getNewStatus ($method);
		$order['customer_notified'] = ($method->send_mail)? 1 : 0;
		$order['comments'] = '';
		$modelOrder->updateStatusForOneOrder ($order['details']['BT']->virtuemart_order_id, $order, TRUE);

		//We delete the old stuff
		//$cart->emptyCart ();
		JRequest::setVar ('html', $html);
		return TRUE;
	}

	/*
		 * Keep backwards compatibility
		 * a new parameter has been added in the xml file
		 */
	function getNewStatus ($method) {

		if (isset($method->status_pending) and $method->status_pending!="") {
			return $method->status_pending;
		} else {
			return 'P';
		}
	}

	/**
	 * Display stored payment data for an order
	 *
	 */
	function plgVmOnShowOrderBEPayment ($virtuemart_order_id, $virtuemart_payment_id) {

		if (!$this->selectedThisByMethodId ($virtuemart_payment_id)) {
			return NULL; // Another method was selected, do nothing
		}

		if (!($paymentTable = $this->getDataByOrderId ($virtuemart_order_id))) {
			return NULL;
		}

		$html = '<table class="adminlist">' . "\n";
		$html .= $this->getHtmlHeaderBE ();
		$html .= $this->getHtmlRowBE ('LIQPAY_PAYMENT_NAME', $paymentTable->payment_name);
		$html .= $this->getHtmlRowBE ('LIQPAY_PAYMENT_TOTAL_CURRENCY', $paymentTable->payment_order_total . ' ' . $paymentTable->payment_currency);
		$html .= '</table>' . "\n";
		return $html;
	}

	function getCosts (VirtueMartCart $cart, $method, $cart_prices) {

		if (preg_match ('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr ($method->cost_percent_total, 0, -1);
		} else {
			$cost_percent_total = $method->cost_percent_total;
		}
		return ($method->cost_per_transaction + ($cart_prices['salesPrice'] * $cost_percent_total * 0.01));
	}

	/**
	 * Check if the payment conditions are fulfilled for this payment method
	 *
	 * @author: Valerie Isaksen
	 *
	 * @param $cart_prices: cart prices
	 * @param $payment
	 * @return true: if the conditions are fulfilled, false otherwise
	 *
	 */
	protected function checkConditions ($cart, $method, $cart_prices) {

		$this->convert ($method);
		// 		$params = new JParameter($payment->payment_params);
		$address = (($cart->ST == 0) ? $cart->BT : $cart->ST);

		// We come from the calculator, the $cart->pricesUnformatted does not exist yet
		//$amount = $cart->pricesUnformatted['billTotal'];
		$amount = $cart_prices['salesPrice'];
		$amount_cond = ($amount >= $method->min_amount AND $amount <= $method->max_amount
			OR
			($method->min_amount <= $amount AND ($method->max_amount == 0)));
		if (!$amount_cond) {
			return FALSE;
		}
		$countries = array();
		if (!empty($method->countries)) {
			if (!is_array ($method->countries)) {
				$countries[0] = $method->countries;
			} else {
				$countries = $method->countries;
			}
		}

		// probably did not gave his BT:ST address
		if (!is_array ($address)) {
			$address = array();
			$address['virtuemart_country_id'] = 0;
		}

		if (!isset($address['virtuemart_country_id'])) {
			$address['virtuemart_country_id'] = 0;
		}
		if (count ($countries) == 0 || in_array ($address['virtuemart_country_id'], $countries) ) {
			return TRUE;
		}

		return FALSE;
	}

	function convert ($method) {

		$method->min_amount = (float)$method->min_amount;
		$method->max_amount = (float)$method->max_amount;
	}

	/*
* We must reimplement this triggers for joomla 1.7
*/

	/**
	 * Create the table for this plugin if it does not yet exist.
	 * This functions checks if the called plugin is active one.
	 * When yes it is calling the standard method to create the tables
	 *
	 * @author Valérie Isaksen
	 *
	 */
	function plgVmOnStoreInstallPaymentPluginTable ($jplugin_id) {

		return $this->onStoreInstallPluginTable ($jplugin_id);
	}

	/**
	 * This event is fired after the payment method has been selected. It can be used to store
	 * additional payment info in the cart.
	 *
	 * @author Max Milbers
	 * @author Valérie isaksen
	 *
	 * @param VirtueMartCart $cart: the actual cart
	 * @return null if the payment was not selected, true if the data is valid, error message if the data is not vlaid
	 *
	 */
	public function plgVmOnSelectCheckPayment (VirtueMartCart $cart, &$msg) {

		return $this->OnSelectCheck ($cart);
	}

	/**
	 * plgVmDisplayListFEPayment
	 * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
	 *
	 * @param object  $cart Cart object
	 * @param integer $selected ID of the method selected
	 * @return boolean True on succes, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 *
	 * @author Valerie Isaksen
	 * @author Max Milbers
	 */
	public function plgVmDisplayListFEPayment (VirtueMartCart $cart, $selected = 0, &$htmlIn) {

		return $this->displayListFE ($cart, $selected, $htmlIn);
	}

	/*
* plgVmonSelectedCalculatePricePayment
* Calculate the price (value, tax_id) of the selected method
* It is called by the calculator
* This function does NOT to be reimplemented. If not reimplemented, then the default values from this function are taken.
* @author Valerie Isaksen
* @cart: VirtueMartCart the current cart
* @cart_prices: array the new cart prices
* @return null if the method was not selected, false if the shiiping rate is not valid any more, true otherwise
*
*
*/

	public function plgVmonSelectedCalculatePricePayment (VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice ($cart, $cart_prices, $cart_prices_name);
	}

	function plgVmgetPaymentCurrency ($virtuemart_paymentmethod_id, &$paymentCurrencyId) {

		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}
		$this->getPaymentCurrency ($method);

		$paymentCurrencyId = $method->payment_currency;
		return;
	}

	/**
	 * plgVmOnCheckAutomaticSelectedPayment
	 * Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
	 * The plugin must check first if it is the correct type
	 *
	 * @author Valerie Isaksen
	 * @param VirtueMartCart cart: the cart object
	 * @return null if no plugin was found, 0 if more then one plugin was found,  virtuemart_xxx_id if only one plugin is found
	 *
	 */
	function plgVmOnCheckAutomaticSelectedPayment (VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) {

		return $this->onCheckAutomaticSelected ($cart, $cart_prices, $paymentCounter);
	}

	/**
	 * This method is fired when showing the order details in the frontend.
	 * It displays the method-specific data.
	 *
	 * @param integer $order_id The order ID
	 * @return mixed Null for methods that aren't active, text (HTML) otherwise
	 * @author Max Milbers
	 * @author Valerie Isaksen
	 */
	public function plgVmOnShowOrderFEPayment ($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name) {

		$this->onShowOrderFE ($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
	}

	/**
	 * This event is fired during the checkout process. It can be used to validate the
	 * method data as entered by the user.
	 *
	 * @return boolean True when the data was valid, false otherwise. If the plugin is not activated, it should return null.
	 * @author Max Milbers

	public function plgVmOnCheckoutCheckDataPayment(  VirtueMartCart $cart) {
	return null;
	}
	 */

	/**
	 * This method is fired when showing when priting an Order
	 * It displays the the payment method-specific data.
	 *
	 * @param integer $_virtuemart_order_id The order ID
	 * @param integer $method_id  method used for this order
	 * @return mixed Null when for payment methods that were not selected, text (HTML) otherwise
	 * @author Valerie Isaksen
	 */
	function plgVmonShowOrderPrintPayment ($order_number, $method_id) {

		return $this->onShowOrderPrint ($order_number, $method_id);
	}

	function plgVmDeclarePluginParamsPayment ($name, $id, &$data) {

		return $this->declarePluginParams ('payment', $name, $id, $data);
	}

	function plgVmSetOnTablePluginParamsPayment ($name, $id, &$table) {

		return $this->setOnTablePluginParams ($name, $id, $table);
	}

	//Notice: We only need to add the events, which should work for the specific plugin, when an event is doing nothing, it should not be added

	/**
	 * Save updated order data to the method specific table
	 *
	 * @param array   $_formData Form data
	 * @return mixed, True on success, false on failures (the rest of the save-process will be
	 * skipped!), or null when this method is not actived.
	 *
	public function plgVmOnUpdateOrderPayment(  $_formData) {
	return null;
	}

	/**
	 * Save updated orderline data to the method specific table
	 *
	 * @param array   $_formData Form data
	 * @return mixed, True on success, false on failures (the rest of the save-process will be
	 * skipped!), or null when this method is not actived.
	 *
	public function plgVmOnUpdateOrderLine(  $_formData) {
	return null;
	}

	/**
	 * plgVmOnEditOrderLineBE
	 * This method is fired when editing the order line details in the backend.
	 * It can be used to add line specific package codes
	 *
	 * @param integer $_orderId The order ID
	 * @param integer $_lineId
	 * @return mixed Null for method that aren't active, text (HTML) otherwise
	 *
	public function plgVmOnEditOrderLineBEPayment(  $_orderId, $_lineId) {
	return null;
	}

	/**
	 * This method is fired when showing the order details in the frontend, for every orderline.
	 * It can be used to display line specific package codes, e.g. with a link to external tracking and
	 * tracing systems
	 *
	 * @param integer $_orderId The order ID
	 * @param integer $_lineId
	 * @return mixed Null for method that aren't active, text (HTML) otherwise
	 *
	public function plgVmOnShowOrderLineFE(  $_orderId, $_lineId) {
	return null;
	}

	/**
	 * This event is fired when the  method notifies you when an event occurs that affects the order.
	 * Typically,  the events  represents for payment authorizations, Fraud Management Filter actions and other actions,
	 * such as refunds, disputes, and chargebacks.
	 *
	 * NOTE for Plugin developers:
	 *  If the plugin is NOT actually executed (not the selected payment method), this method must return NULL
	 *
	 * @param         $return_context: it was given and sent in the payment form. The notification should return it back.
	 * Used to know which cart should be emptied, in case it is still in the session.
	 * @param int     $virtuemart_order_id : payment  order id
	 * @param char    $new_status : new_status for this order id.
	 * @return mixed Null when this method was not selected, otherwise the true or false
	 *
	 * @author Valerie Isaksen
	 *
	 */
	public function plgVmOnPaymentNotification() {
        if (!class_exists ('VirtueMartModelOrders')) {
        	require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
        }
        // Get POST data
        $post_data = JRequest::get ('post');
        // Log POST data for all request
        $this->logInfo (json_encode($post_data), 'message');
        
        if (!isset($post_data['operation_xml'])) {
			return NULL;
		}
        
        $response_xml = base64_decode($post_data['operation_xml']);
        $response_xmlObject = new SimpleXMLElement($response_xml);
        $order_number = $response_xmlObject->order_id;
        if(!$order_number){
            return NULL;
        }
        // Check response IP's
        if(!$this->_checkLiqpayIps($order_number)){
            return false;
        }
        // Verify the existence of the order
        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber ($order_number) ) ) {
			return FALSE;
		}
        // Get method
        if (!($payments = $this->getDatasByOrderId ($virtuemart_order_id))) {
			return FALSE;
		}
        $method = $this->getVmPluginMethod ($payments[0]->virtuemart_paymentmethod_id);
        // Check if it is the correct element
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}
        
        if(!$this->_checkLiqpayResponseSignature($post_data, $method)){
            return FALSE;
        }
        // Log POST data
        $this->logInfo ('plgVmOnPaymentNotification ' . __LINE__ . ' : liqpay_data ' . json_encode($post_data), 'message');
        
        $modelOrder = VmModel::getModel ('orders');
		$order = array();
        
        $response_order_status = $response_xmlObject->status;
        // Check the payment_status is "success"
		if (strcmp ($response_order_status, 'success') == 0) {
			$order['order_status'] = $method->status_success;
        // Check the payment_status is "failure"
		}elseif(strcmp ($response_order_status, 'failure') == 0){
            $order['order_status'] = $method->status_failure;
        // Check the payment_status is "wait_secure"
		}elseif(strcmp ($response_order_status, 'wait_secure') == 0){
            $order['order_status'] = $method->status_waitsecure;
		}
        
        $this->logInfo ('plgVmOnPaymentNotification return new_status:' . $order['order_status'], 'message');

		$modelOrder->updateStatusForOneOrder ($virtuemart_order_id, $order, TRUE);
	}

	/**
	 * plgVmOnPaymentResponseReceived
	 * This event is fired when the  method returns to the shop after the transaction
	 *
	 *  the method itself should send in the URL the parameters needed
	 * NOTE for Plugin developers:
	 *  If the plugin is NOT actually executed (not the selected payment method), this method must return NULL
	 *
	 * @param int     $virtuemart_order_id : should return the virtuemart_order_id
	 * @param text    $html: the html to display
	 * @return mixed Null when this method was not selected, otherwise the true or false
	 *
	 * @author Aleksandr Artamonov
     * @site http://w3strict.ru/
	 *
	 */
	function plgVmOnPaymentResponseReceived(&$virtuemart_order_id, &$html) 
    {
        // Check class exists
        if (!class_exists ('VirtueMartCart')){
        	require(JPATH_VM_SITE.DS.'helpers'.DS.'cart.php');
        }
        if (!class_exists ('shopFunctionsF')){
        	require(JPATH_VM_SITE.DS.'helpers'.DS.'shopfunctionsf.php');
        }
        if (!class_exists ('VirtueMartModelOrders')){
        	require(JPATH_VM_ADMINISTRATOR.DS.'models'.DS.'orders.php');
        }
        
        // Get variables request
        $paymentmethod_id = JRequest::getInt ('pmi', 0);
        $order_number = JRequest::getString ('on', 0);
        
        // Get Method
        if (!($method = $this->getVmPluginMethod ($paymentmethod_id))) {
        	return NULL;
        }
        // Check if it is the correct element
        if (!$this->selectedThisElement ($method->payment_element, true)) {
        	return NULL;
        }
        // Get/check order number
        if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber ($order_number))) {
        	return NULL;
        }
        // Get order data
        if (!($paymentTable = $this->getDataByOrderId ($virtuemart_order_id))) {
        	return '';
        }
        $order_data = VirtueMartModelOrders::getOrder ($virtuemart_order_id);
        
        $payment_name = $this->renderPluginName ($method);
        $html = $this->_getPaymentResponseHtml ($paymentTable, $payment_name, $method, $order_data);
        
        // Get the correct cart / session
        $cart = VirtueMartCart::getCart ();
        
        // Delete the old cart
        $cart->emptyCart ();
        return TRUE;
    }
    
    /**
     * Format HTML for order detail
     * 
	 * @param $paymentTable
	 * @param $payment_name
	 * @return string
     * 
	 * @author Aleksandr Artamonov
     * @site http://w3strict.ru/     
	 */
	private function _getPaymentResponseHtml ($paymentTable, $payment_name, $method, $order_data)
    {
        $patterns = array();
        $patterns[0] = '/{lp_payment_name_title}/';
        $patterns[1] = '/{lp_payment_name}/';
        $patterns[2] = '/{lp_amount_title}/';
        $patterns[3] = '/{lp_amount}/';
        $patterns[4] = '/{lp_order_number_title}/';
        $patterns[5] = '/{lp_order_number}/';
        $patterns[6] = '/{lp_status_word}/';
        $patterns[7] = '/{lp_status}/';
        $replacements = array();
        $replacements[7] = JText::_('VMPAYMENT_LIQPAY_PAYMENTNAME');
        $replacements[6] = $payment_name;
        $replacements[5] = JText::_('VMPAYMENT_LIQPAY_AMOUNT');
        $replacements[4] = $paymentTable->payment_order_total. " " . $paymentTable->payment_currency;
        $replacements[3] = JText::_('VMPAYMENT_LIQPAY_ORDERNUMBER');
        $replacements[2] = $paymentTable->order_number;
        $replacements[1] = JText::_('VMPAYMENT_LIQPAY_STATUS');
        $replacements[0] = $order_data['details']['BT']->order_status_name;
        
        switch($order_data['details']['BT']->order_status){
            case $method->status_success:
                return preg_replace($patterns, $replacements, $method->payment_response_success_html);
                break;
            case $method->status_failure:
                return preg_replace($patterns, $replacements, $method->payment_response_failure_html);
                break;
            case $method->status_waitsecure:
                return preg_replace($patterns, $replacements, $method->payment_response_waitsecure_html);
                break;
            case $method->status_pending:
                return preg_replace($patterns, $replacements, $method->payment_response_pending_html);
                break;
        }
	}
    
    /**
     * Verify that the answer came from a trusted ip-address
     *  
	 * @param $order_number
	 * @return boolean
     * 
	 * @author Aleksandr Artamonov
     * @site http://w3strict.ru/
	 */
	private function _checkLiqpayIps($order_number){
        // for test
        // return true;
        $start_mask = ip2long('75.101.155.1');
        $end_mask = ip2long('75.101.155.255');
        $myip = ip2long($_SERVER['REMOTE_ADDR']);
        
        $this->logInfo ('_checkLiqpayIps: server is: ' . $_SERVER['REMOTE_ADDR'], 'message');
        
        if($myip > $start_mask AND $myip < $end_mask){
            $this->logInfo ('_checkLiqpayIps:  OK', 'message');
            return true;
        }else{
            // Prepare e-mail for Vendor and Admin
			$mail_subject = "LiqPay Transaction on your site: Possible fraud";
			$mail_body = "Possible fraud. Error with REMOTE IP ADDRESS = " . $_SERVER['REMOTE_ADDR'] . ".
                        The remote address of the script posting to this notify script does not match a valid LiqPay ip address\n
            These are the valid IP Addresses: 75.101.155.*
            The Order ID received was: " . $order_number;
            // Send e-mail to Vendor and Admin
			$this->sendEmailToVendorAndAdmins ($mail_subject, $mail_body);
            
            return false;
        }
	}
    /**
     * Check response signature
     * 
     * @param $post_data
     * @param $method - содержит в себе настройки плагина(в данном случае нам нужена сигнатура мерчанта)
     * 
     * @return boolean
     * 
	 * @author Aleksandr Artamonov
     * @site http://w3strict.ru/
     */
    private function _checkLiqpayResponseSignature($post_data, $method){
        // for test
        // return TRUE;
        $sign=base64_encode(sha1($method->merc_sign.$post_data['operation_xml'].$method->merc_sign,1));
        
        if($post_data['signature'] == $sign){
            return TRUE;
        }else{
            return FALSE;
        }
    }
}
// No closing tag
